    <form action="{{route('filtrar')}}" method="post">
        @csrf
        <ul class="listview image-listview">
            <li>
                <input type="hidden" name="estado" id="estado" value="{{ $estado->uf }}">
                <a href="#" data-toggle="modal" data-target="#lista_estados" class="item">
                    <img src="{{ url('app') }}/assets/img/estados/{{ $estado->thumb }}" alt="image"
                        class="image">
                    <div class="in">
                        <div>{{ $estado->nome }}</div>
                        <span class="badge badge-primary"></span>
                    </div>
                </a>
            </li>
            <li>
                <input type="hidden" name="cidade" id="cidade" value="{{ $cidade }}">
                <a href="#" data-toggle="modal" data-target="#lista_cidades" class="item">
                    <img src="{{ url('app') }}/assets/img/estados/{{ $estado->thumb }}" alt="image"
                        class="image">
                    <div class="in">
                        <div>{{ $cidade }}</div>
                        <span class="badge badge-primary"></span>
                    </div>
                </a>
            </li>
            <li>
                <input type="hidden" name="categoria_id" id="categoria" value="{{ $categoria->id }}">
                <a href="#" data-toggle="modal" data-target="#lista_categorias" class="item">
                    <img src="{{ url("storage/{$categoria->ico}") }}" alt="image" class="image">
                    <div class="in">
                        <div>{{ $categoria->titulo }}</div>
                        <span class="badge badge-primary"></span>
                    </div>
                </a>
            </li>
            <li>
                <input type="hidden" name="sub_categoria_id" id="sub" value="{{ $sub->id }}">
                <a href="#" data-toggle="modal" data-target="#lista_subs" class="item">
                    <img src="{{ url("storage/{$categoria->ico}") }}" alt="image" class="image">
                    <div class="in">
                        <div>{{ $sub->titulo }}</div>
                        <span class="badge badge-primary"></span>
                    </div>
                </a>
            </li>
        </ul>
        <div class="section full mt-2 ml-2 mr-2">
            <button id="buscar" type="submit" class="btn btn-primary btn-block">BUSCAR</button>
        </div>
    </form>


    <div class="modal fade modalbox" id="lista_estados" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Estados</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview image-listview flush mb-2">
                        @foreach ($estados as $result)
                            <li onclick="javascript:setEstado({{ $result->setEstado->id }})">
                                <div class="item">
                                    <img src="{{ url('app') }}/assets/img/estados/{{ $result->setEstado->thumb }}"
                                        alt="image" class="image">
                                    <div class="in">
                                        <div>{{ $result->setEstado->nome }}</div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade modalbox" id="lista_cidades" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cidades</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview image-listview flush mb-2">
                        @foreach ($cidades as $cidade)
                            <li onclick="javascript:Cidade({{ $cidade->id }})">
                                <div class="item">
                                    <img src="{{ url('app') }}/assets/img/estados/{{ $estado->thumb }}"
                                        alt="image" class="image">
                                    <div class="in">
                                        <div>{{ $cidade->cidade }}</div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade modalbox" id="lista_categorias" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Categorias</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview image-listview flush mb-2">
                        @foreach ($categorias as $categoria)
                            <li onclick="javascript:Categoria({{ $categoria->categoria->id }})">
                                <div class="item">
                                    <img src="{{ url("storage/{$categoria->categoria->ico}") }}" alt="image"
                                        class="image">
                                    <div class="in">
                                        <div>{{ $categoria->categoria->titulo }}</div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade modalbox" id="lista_subs" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Sub-categorias</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview link-listview">
                        @foreach ($subs as $sub)
                            <li><a href="#"
                                    onclick="javascript:Sub({{ $sub->sub->id }});">{{ $sub->sub->titulo }}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
